#include <stdio.h>
#include "../include/PETs.h"

int main(int argc, char* argv[])
{
	unsigned int modaddr=0;
	int res;
	double dval = 0;
	int major, minor;
	int cds, status;
	int valid,devvalid;
	unsigned long chkshort;
	
	if (argc < 2)
	{ 
		printf("Error!  Please specify [Module Address]!\n");
		printf("Example : single-test 0\n");
		return 1;
	}
	modaddr = atoi(argv[1]);

/*********************************
Single card test 
**********************************/

	status = INIT2(modaddr);
	valid = VALIDPEM(modaddr);
	if ( valid == 0) 
	{
		printf("pem[%d] is not exist\n", modaddr);
//		return -1;
	}			
	else
	{
		devvalid = VALIDDEV2(modaddr);
		if (devvalid == 0) 
		{
			printf("Dev  is not match, try rescan\n");

//			return -1;
		}

		GETLIBVER(&major, &minor);
		printf("lib version = %d.%d, cds=%d\n", major, minor, cds);

		cds= CHECKCD2(modaddr);
		printf("lib version = %d.%d, cds=%d\n", major, minor, cds);

		
		res = GET3V3I2(modaddr,&dval);
		if (res == 0)
		{
			printf("3.3V Current = %f\n", dval);
		}
		else if (res == PEMCTRL_ERROR_ADCNOTEXIST)
		{
			printf("ADC Not Exist!\n");
		}
		else 
		{
			printf("Get 3V3 Current  failed! status = %d\n", res);
		}	
		res = GET3V3V2(modaddr,&dval);
		if (res == 0)
		{
			printf("3.3V Voltage = %f\n", dval);
		}
		else if (res == PEMCTRL_ERROR_ADCNOTEXIST)
		{
			printf("ADC Not Exist!\n");
		}
		else 
		{
			printf("Get 3V3 Voltage  failed! status = %d\n", res);
		}	
		res = GET12VV2(modaddr,&dval);
		if (res == 0)
		{
			printf("12V Voltage = %f\n", dval);
		}
		else if (res == PEMCTRL_ERROR_ADCNOTEXIST)
		{
			printf("ADC Not Exist!\n");
		}
		else 
		{
			printf("Get 12V Voltage  failed! status = %d\n", res);
		}
		res = GET12VI2(modaddr,&dval);
		if (res == 0)
		{
			printf("12V Current = %f\n", dval);
		}
		else if (res == PEMCTRL_ERROR_ADCNOTEXIST)
		{
			printf("ADC Not Exist!\n");
		}
		else 
		{
			printf("Get 12V Current failed! status = %d\n", res);
		}

		// swap card test
		printf("Swap card Test....\n");
	
		POFF2(modaddr);
		printf("Unplug test card & Plug another test card....\n");
		usleep(500000);
		getchar();

		status = PON2(modaddr);

		if (status == 0)
		{
			printf("Power on!\n");

		}
		else
		{
			printf("Power on  failed!\n");
			chkshort = CHKSHORT(modaddr);
				
			if (chkshort & PEMCTRL_ERROR_3V3AUXSHORT) printf("3.3V Aux Short!\n");
			if (chkshort & PEMCTRL_ERROR_3V3SHORT) printf("3.3V Short!\n");
			if (chkshort & PEMCTRL_ERROR_1V5SHORT) printf("1.5V Short!\n");
		}	
		RESCAN2(modaddr);
	}
	EXIT(modaddr);		


	return 0;
}
